'--------------------------------------------------------------------
'                  ADC.BAS
'  demonstration of GETADC() function for 8535 micro
'  Getadc() will also work for other AVR chips that have an ADC converter
'--------------------------------------------------------------------
'$regfile = "m163def.dat"

'configure single mode and auto prescaler setting
'The single mode must be used with the GETADC() function

'The prescaler divides the internal clock by 2,4,8,15,32,64 or 128
'Because the ADC needs a clock from 50-200 KHz
'The AUTO feature, will select the highest clockrate possible
Config Adc = Single , Prescaler = Auto
'Now give power to the chip
Start Adc

'With STOP ADC, you can remove the power from the chip
'Stop Adc

Dim W As Word , Channel As Byte
print
Print "Hit key 0-7 for select channel adc to test."
Do
Do
Channel = Waitkey()                                         'select channel
Channel = Channel - &H30
Loop Until Channel >= 0
Loop Until Channel < 8
'now read A/D value from channel 0

Do
  W = Getadc(channel)
  Print "Channel " ; Channel ; " value " ; W ; "   " ;
'send cariage return
$asm
ldi  r16,13
Out Udr , R16
$end Asm

Loop
End

'The new M163 has options for the reference voltage
'For this chip you can use the additional param :
'The reference param may be :
'Config Adc = Single , Prescaler = Auto , Reference = Internal
'OFF      : AREF, internal reference turned off
'AVCC     : AVCC, with external capacitor at AREF pin
'INTERNAL : Internal 2.56 voltage reference with external capacitor ar AREF pin

'Using the additional param on chip that do not have the internal reference will have no effect.